/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.swingsuite;

public abstract class TextEntryMask {
    protected abstract Integer getCodePoint(String var1, int var2, int var3);

    protected abstract int getLength();

    protected abstract int getDefaultCodePoint(int var1);

    protected abstract int getNextValidInputPosition(int var1);

    boolean isTextValid(String text) {
        if (text.length() != this.getLength()) {
            return false;
        }
        int i = text.length() - 1;
        while (i >= 0) {
            int codePoint = text.codePointAt(i);
            if (this.getCodePoint(text, codePoint, i) == null) {
                return false;
            }
            --i;
        }
        return true;
    }

    String getDefaultText() {
        int[] chars = new int[this.getLength()];
        int i = 0;
        while (i < chars.length) {
            chars[i] = this.getDefaultCodePoint(i);
            ++i;
        }
        return new String(chars, 0, chars.length);
    }

    private static int[] getCodePoints(String s) {
        int[] codePoints = new int[s.length()];
        int i = 0;
        while (i < codePoints.length) {
            codePoints[i] = s.codePointAt(i);
            ++i;
        }
        return codePoints;
    }

    String insertText(String text, String textToInsert, int position) {
        int length = this.getLength();
        if (text.length() != length) {
            return null;
        }
        if (position + textToInsert.length() > length) {
            return null;
        }
        int[] codePoints = TextEntryMask.getCodePoints(text);
        int i = textToInsert.length() - 1;
        while (i >= 0) {
            Integer codePointToInsert = this.getCodePoint(text, textToInsert.codePointAt(i), position + i);
            if (codePointToInsert == null) {
                return null;
            }
            codePoints[position + i] = codePointToInsert;
            --i;
        }
        return new String(codePoints, 0, codePoints.length);
    }

    String removeText(String text, int position, int length) {
        int[] codePoints = TextEntryMask.getCodePoints(text);
        int i = position + length - 1;
        while (i >= position) {
            codePoints[i] = this.getDefaultCodePoint(i);
            --i;
        }
        return new String(codePoints, 0, codePoints.length);
    }
}

