/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.swingsuite;

import chrriis.dj.swingsuite.AutoScrollActivator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class SwingSuiteUtilities {
    public static final boolean IS_JAVA_6_OR_GREATER = System.getProperty("java.version").compareTo("1.6") >= 0;
    private static final SelectAllOnFocusListener SELECT_ALL_ON_FOCUS_LISTENER = new SelectAllOnFocusListener();

    private SwingSuiteUtilities() {
    }

    static void setComponentTreeEnabled(Component component, boolean isEnabled) {
        component.setEnabled(isEnabled);
        if (component instanceof Container) {
            int componentCount = ((Container)component).getComponentCount();
            int i = 0;
            while (i < componentCount) {
                SwingSuiteUtilities.setComponentTreeEnabled(((Container)component).getComponent(i), isEnabled);
                ++i;
            }
        }
    }

    public static void setSelectAllOnFocus(JTextComponent component, boolean isSelectingAllOnFocus) {
        component.removeFocusListener(SELECT_ALL_ON_FOCUS_LISTENER);
        component.removeMouseListener(SELECT_ALL_ON_FOCUS_LISTENER);
        component.removeMouseMotionListener(SELECT_ALL_ON_FOCUS_LISTENER);
        if (isSelectingAllOnFocus) {
            MouseListener[] mouseListeners = component.getMouseListeners();
            int i = 0;
            while (i < mouseListeners.length) {
                component.removeMouseListener(mouseListeners[i]);
                ++i;
            }
            component.addMouseListener(SELECT_ALL_ON_FOCUS_LISTENER);
            i = 0;
            while (i < mouseListeners.length) {
                component.addMouseListener(mouseListeners[i]);
                ++i;
            }
            MouseMotionListener[] mouseMotionListeners = component.getMouseMotionListeners();
            int i2 = 0;
            while (i2 < mouseMotionListeners.length) {
                component.removeMouseMotionListener(mouseMotionListeners[i2]);
                ++i2;
            }
            component.addMouseMotionListener(SELECT_ALL_ON_FOCUS_LISTENER);
            i2 = 0;
            while (i2 < mouseMotionListeners.length) {
                component.addMouseMotionListener(mouseMotionListeners[i2]);
                ++i2;
            }
            component.addFocusListener(SELECT_ALL_ON_FOCUS_LISTENER);
        }
    }

    public static boolean isSelectingAllOnFocus(JTextComponent textComponent) {
        FocusListener[] focusListenerArray = textComponent.getFocusListeners();
        int n = focusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FocusListener focusListener = focusListenerArray[n2];
            if (SELECT_ALL_ON_FOCUS_LISTENER.equals(focusListener)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static String getUIManagerMessage(String managerKey, String defaultMessage, Object ... params) {
        String message = UIManager.getString(managerKey);
        return MessageFormat.format(message != null ? message : defaultMessage, params);
    }

    public static void adjustToolbarButtonFocus(AbstractButton toolBarButton) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel.isNativeLookAndFeel() && System.getProperty("os.name").startsWith("Windows") && !Boolean.parseBoolean(System.getProperty("swing.noxp")) && !lookAndFeel.getClass().getName().endsWith("WindowsClassicLookAndFeel")) {
            toolBarButton.setFocusPainted(false);
        }
    }

    public static void setAutoScrollEnabled(JComponent component, boolean isEnabled) {
        AutoScrollActivator.setAutoScrollEnabled(component, isEnabled);
    }

    public static void autoFitTableColumns(JTable table, int maxWidth) {
        SwingSuiteUtilities.autoFitTableColumn(table, -1, maxWidth);
    }

    public static void autoFitTableColumn(JTable table, int columnIndex, int maxWidth) {
        TableModel model = table.getModel();
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int rowCount = table.getRowCount();
        int rowMargin = table.getRowMargin();
        TableColumnModel columnModel = table.getColumnModel();
        int viewCol = columnIndex >= 0 ? columnIndex : model.getColumnCount() - 1;
        while (viewCol >= 0) {
            TableColumn tableColumn = columnModel.getColumn(viewCol);
            int headerWidth = headerRenderer.getTableCellRendererComponent((JTable)table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)viewCol).getPreferredSize().width;
            int cellWidth = 0;
            int viewRow = 0;
            while (viewRow < rowCount) {
                Component comp = table.getCellRenderer(viewRow, viewCol).getTableCellRendererComponent(table, table.getValueAt(viewRow, viewCol), false, false, viewRow, viewCol);
                int preferredWidth = comp.getPreferredSize().width;
                if (Math.max(headerWidth, cellWidth = Math.max(cellWidth, preferredWidth += 10)) + rowMargin >= maxWidth) break;
                ++viewRow;
            }
            tableColumn.setPreferredWidth(Math.min(Math.max(headerWidth += 20, cellWidth) + rowMargin, maxWidth));
            if (columnIndex >= 0) break;
            --viewCol;
        }
    }

    public static String decodeURL(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeURL(String s) {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            encodedString = URLEncoder.encode(s);
        }
        return encodedString.replaceAll("\\+", "%20");
    }

    public static String escapeXML(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String convertWildcardsToRegExp(String wildcardString) {
        return "\\Q" + wildcardString.replace("\\E", "\\\\E").replace("\\Q", "\\\\Q").replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
    }

    public static void setPreferredLookAndFeel() {
        try {
            String systemLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
            if (!"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(systemLookAndFeelClassName)) {
                UIManager.setLookAndFeel(systemLookAndFeelClassName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SelectAllOnFocusListener
    extends MouseAdapter
    implements MouseMotionListener,
    FocusListener {
        private boolean isSettingFocus;
        private Point mouseLocation = null;

        private SelectAllOnFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.isSettingFocus = true;
            ((JTextComponent)e.getComponent()).selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.isSettingFocus = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.mouseLocation = e.getPoint();
                this.isSettingFocus = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                if (this.isSettingFocus) {
                    e.consume();
                }
                this.isSettingFocus = false;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.mouseLocation = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if ((e.getModifiersEx() & 0x400) != 0 && this.mouseLocation != null) {
                if (this.isSettingFocus && Math.abs(this.mouseLocation.x - e.getX()) < 5) {
                    e.consume();
                } else {
                    ((JTextComponent)e.getComponent()).setCaretPosition(((JTextComponent)e.getComponent()).viewToModel(this.mouseLocation));
                    this.mouseLocation = null;
                }
            }
        }
    }
}

