/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.swingsuite;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class JTitledSeparator
extends JPanel {
    private SeparatorPane westSeparator;
    private JLabel label = new JLabel();

    public JTitledSeparator(String title) {
        super(new BorderLayout());
        JPanel westPanel = new JPanel(new BorderLayout()){

            @Override
            public void reshape(int x, int y, int w, int h) {
                super.reshape(x, y, w, h);
                this.doLayout();
            }
        };
        westPanel.setOpaque(false);
        westPanel.setDoubleBuffered(false);
        this.westSeparator = new SeparatorPane();
        boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
        if (isLeftToRight) {
            this.westSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
            westPanel.add((Component)this.westSeparator, "West");
        } else {
            this.westSeparator.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
            westPanel.add((Component)this.westSeparator, "East");
        }
        this.setOpaque(false);
        westPanel.add((Component)this.label, "Center");
        if (isLeftToRight) {
            this.add((Component)westPanel, "West");
        } else {
            this.add((Component)westPanel, "East");
        }
        SeparatorPane separatorPane = new SeparatorPane();
        if (isLeftToRight) {
            separatorPane.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        } else {
            separatorPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        }
        this.add((Component)separatorPane, "Center");
        this.setTitle(title);
        this.adjustLook();
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        boolean isVisible = title.length() != 0;
        this.westSeparator.setVisible(isVisible);
        this.label.setVisible(isVisible);
        this.label.setText(title);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.adjustLook();
    }

    private void adjustLook() {
        if (this.westSeparator != null) {
            this.westSeparator.setPreferredSize(new Dimension(new JLabel((String)"M").getPreferredSize().width, this.westSeparator.getPreferredSize().height));
        }
        if (this.label != null) {
            Color titleColor = UIManager.getColor("TitledBorder.titleColor");
            Font font = UIManager.getFont("TitledBorder.font");
            if (titleColor == null || font == null) {
                TitledBorder titledBorder = new TitledBorder("");
                titleColor = titledBorder.getTitleColor();
                font = titledBorder.getTitleFont();
            }
            this.label.setForeground(titleColor);
            this.label.setFont(font);
        }
    }

    private final class SeparatorPane
    extends JPanel {
        private SeparatorPane() {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.setDoubleBuffered(false);
            JSeparator separator = new JSeparator(){

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    Composite composite = g2d.getComposite();
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
                    super.paintComponent(g);
                    g2d.setComposite(composite);
                }
            };
            this.add((Component)separator, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public void reshape(int x, int y, int w, int h) {
            super.reshape(x, y, w, h);
            this.doLayout();
        }
    }
}

