/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.swingsuite;

import chrriis.dj.swingsuite.LinkListener;
import chrriis.dj.swingsuite.SwingSuiteUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class JLink<T>
extends JLabel {
    private boolean isDefaultToolTipShown;
    private T target;

    public JLink(String text, T target) {
        this(text, target, null);
    }

    public JLink(String text, T target, String toolTip) {
        super(text);
        this.isDefaultToolTipShown = toolTip == null;
        this.setToolTipText(toolTip);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setForeground(Color.BLUE);
        HashMap<TextAttribute, Integer> attributeMap = new HashMap<TextAttribute, Integer>();
        attributeMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        this.setFont(this.getFont().deriveFont(attributeMap));
        this.setTarget(target);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JLink.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JLink.this.repaint();
            }
        });
        MouseInputAdapter mouseListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JLink.this.setForeground(Color.RED);
                JLink.this.requestFocus();
                JLink.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JLink.this.setForeground(Color.BLUE);
                JLink.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    JLink.this.fireLinkActivated();
                }
            }
        };
        this.setFocusTraversalKeysEnabled(true);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    JLink.this.fireLinkActivated();
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!SwingSuiteUtilities.IS_JAVA_6_OR_GREATER) {
            FontMetrics fm = g.getFontMetrics();
            int y = fm.getHeight() - fm.getDescent() + 1;
            g.drawLine(0, y, this.getWidth(), y);
        }
        if (this.hasFocus()) {
            BasicGraphicsUtils.drawDashedRect(g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void fireLinkActivated() {
        LinkListener<T>[] linkListenerArray = this.getLinkListeners();
        int n = linkListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinkListener<T> linkListener = linkListenerArray[n2];
            if (!linkListener.linkActivated(this, this.target)) {
                return;
            }
            ++n2;
        }
        try {
            if (this.target instanceof String) {
                String s = (String)this.target;
                if (s.startsWith("file:")) {
                    Desktop.getDesktop().open(new File(new URI(s)));
                    return;
                }
                if (s.startsWith("mailto:")) {
                    Desktop.getDesktop().mail(new URI(s));
                    return;
                }
                Desktop.getDesktop().browse(new URI(s));
                return;
            }
            if (this.target instanceof File) {
                Desktop.getDesktop().open((File)this.target);
                return;
            }
            if (this.target instanceof URL) {
                URL url = (URL)this.target;
                String protocol = url.getProtocol();
                if (protocol.startsWith("file:")) {
                    Desktop.getDesktop().open(new File(url.toURI()));
                    return;
                }
                if (protocol.startsWith("mailto:")) {
                    Desktop.getDesktop().mail(url.toURI());
                    return;
                }
                Desktop.getDesktop().browse(url.toURI());
                return;
            }
            if (this.target instanceof URI) {
                URI uri = (URI)this.target;
                String scheme = uri.getScheme();
                if (scheme.startsWith("file:")) {
                    Desktop.getDesktop().open(new File(uri));
                    return;
                }
                if (scheme.startsWith("mailto:")) {
                    Desktop.getDesktop().mail(uri);
                    return;
                }
                Desktop.getDesktop().browse(uri);
                return;
            }
        }
        catch (Throwable ex) {
            JOptionPane.showMessageDialog(this, SwingSuiteUtilities.getUIManagerMessage("Link.linkActivationErrorMessage", "Failed to open the link \"{0}\".", this.target), SwingSuiteUtilities.getUIManagerMessage("Link.linkActivationErrorTitle", "Link error", new Object[0]), 0);
        }
    }

    @Override
    public void setToolTipText(String text) {
        boolean bl = this.isDefaultToolTipShown = text == null;
        if (text == null && this.target != null) {
            text = this.target.toString();
        }
        super.setToolTipText(text);
    }

    public void setTarget(T target) {
        this.target = target;
        if (this.isDefaultToolTipShown) {
            this.setToolTipText(null);
        }
    }

    public T getTarget() {
        return this.target;
    }

    public void addLinkListener(LinkListener<T> linkListener) {
        this.listenerList.add(LinkListener.class, linkListener);
    }

    public void removeLinkListener(LinkListener<T> linkListener) {
        this.listenerList.remove(LinkListener.class, linkListener);
    }

    public LinkListener<T>[] getLinkListeners() {
        return (LinkListener[])this.listenerList.getListeners(LinkListener.class);
    }
}

