/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.swingsuite;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class JComboButton
extends JButton {
    private static final String ARROW_EVENT_SUFFIX = "[Arrow]";
    private MouseInputAdapter mouseHandler = new MouseInputAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            JComboButton.this.setActionCommand(JComboButton.this.originalActionCommand);
            JComboButton.this.originalActionCommand = null;
            JComboButton.this.isMouseOver = false;
            JComboButton.this.isArrowMouseOver = false;
            JComboButton.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JComboButton.this.originalActionCommand = JComboButton.this.getActionCommand();
            JComboButton.this.isMouseOver = true;
            this.processMouseEvent(e);
            JComboButton.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.processMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.processMouseEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (JComboButton.this.getComponentOrientation().isLeftToRight()) {
                int right = ((JComboButton)JComboButton.this).originalBorder.getBorderInsets((Component)e.getComponent()).right + JComboButton.this.arrowSpaceWidth;
                JComboButton.this.isArrowMouseOver = e.getX() > JComboButton.this.getWidth() - right;
            } else {
                int left = ((JComboButton)JComboButton.this).originalBorder.getBorderInsets((Component)e.getComponent()).left + JComboButton.this.arrowSpaceWidth;
                JComboButton.this.isArrowMouseOver = e.getX() < left;
            }
            if (JComboButton.this.isArrowMouseOver && JComboButton.this.isDivided) {
                JComboButton.this.setActionCommand(String.valueOf(JComboButton.this.originalActionCommand) + JComboButton.ARROW_EVENT_SUFFIX);
            } else {
                JComboButton.this.setActionCommand(JComboButton.this.originalActionCommand);
            }
        }
    };
    private String originalActionCommand;
    private Border originalBorder;
    private boolean isMouseOver;
    private boolean isArrowMouseOver;
    private int arrowWidth;
    private int arrowSpaceWidth;
    private boolean isKeyEvent;
    private boolean isDivided;
    private JPopupMenu arrowPopupMenu;

    public JComboButton(Action action, boolean isDivided) {
        super("M");
        this.init(isDivided);
        this.setAction(action);
    }

    public JComboButton(boolean isDivided) {
        this(null, null, isDivided);
    }

    public JComboButton(Icon icon, boolean isDivided) {
        this(null, icon, isDivided);
    }

    public JComboButton(String text, boolean isDivided) {
        this(text, null, isDivided);
    }

    public JComboButton(String text, Icon icon, boolean isDivided) {
        super("M");
        this.init(isDivided);
        this.setText(text);
        this.setIcon(icon);
    }

    private void init(boolean isDivided) {
        this.arrowWidth = this.getPreferredSize().height / 4;
        this.arrowWidth -= (this.arrowWidth + 1) % 2;
        this.arrowSpaceWidth = this.arrowWidth + 7;
        this.setText(null);
        this.setDivided(isDivided);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if ((changeFlags & 1L) != 0L && e.getChanged() == JComboButton.this) {
                    Container parent = JComboButton.this.getParent();
                    if (parent != null) {
                        if (JComboButton.this.originalBorder == null) {
                            JComboButton.this.originalBorder = JComboButton.this.getBorder();
                            if (JComboButton.this.getComponentOrientation().isLeftToRight()) {
                                JComboButton.this.setBorder(BorderFactory.createCompoundBorder(JComboButton.this.originalBorder, BorderFactory.createEmptyBorder(0, 0, 0, JComboButton.this.arrowSpaceWidth + 1)));
                            } else {
                                JComboButton.this.setBorder(BorderFactory.createCompoundBorder(JComboButton.this.originalBorder, BorderFactory.createEmptyBorder(0, JComboButton.this.arrowSpaceWidth + 1, 0, 0)));
                            }
                        }
                    } else {
                        JComboButton.this.setBorder(JComboButton.this.originalBorder);
                        JComboButton.this.originalBorder = null;
                    }
                }
            }
        });
        this.setModel(new DefaultButtonModel(){

            @Override
            public boolean isPressed() {
                return super.isPressed() && JComboButton.this.isDivided && (!JComboButton.this.isArrowMouseOver || JComboButton.this.isKeyEvent);
            }
        });
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.enableEvents(8L);
    }

    private boolean showPopup(ActionEvent e) {
        boolean oldIsArrowMouseOver = this.isArrowMouseOver;
        this.isArrowMouseOver = false;
        this.getModel().setPressed(false);
        this.isArrowMouseOver = oldIsArrowMouseOver;
        if (JComboButton.isArrowEvent(e)) {
            this.requestFocus();
            if (this.arrowPopupMenu != null) {
                this.arrowPopupMenu.show(this, this.getComponentOrientation().isLeftToRight() ? 0 : this.getWidth() - this.arrowPopupMenu.getPreferredSize().width, this.getHeight());
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        try {
            this.isKeyEvent = true;
            if (e.getKeyCode() == 40) {
                if (e.getID() == 401) {
                    this.fireActionPerformed_(new ActionEvent(this, 1001, String.valueOf(this.getOriginalActionEvent()) + ARROW_EVENT_SUFFIX, e.getModifiers()));
                }
                e.consume();
                return;
            }
            super.processKeyEvent(e);
        }
        finally {
            this.isKeyEvent = false;
        }
    }

    public static boolean isArrowEvent(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        return actionCommand != null && actionCommand.endsWith(ARROW_EVENT_SUFFIX);
    }

    private String getOriginalActionEvent() {
        String command = this.getActionCommand();
        if (command == null) {
            return "";
        }
        if (command.endsWith(ARROW_EVENT_SUFFIX)) {
            return command.substring(0, command.length() - ARROW_EVENT_SUFFIX.length());
        }
        return command;
    }

    @Override
    protected void fireActionPerformed(ActionEvent e) {
        boolean isArrowEvent = JComboButton.isArrowEvent(e);
        if (!this.isDivided || this.isArrowMouseOver == isArrowEvent) {
            if (this.isKeyEvent && isArrowEvent) {
                e = new ActionEvent(this, 1001, this.getOriginalActionEvent(), e.getWhen(), e.getModifiers());
            } else if (!this.isDivided && !isArrowEvent) {
                e = new ActionEvent(this, 1001, String.valueOf(this.getOriginalActionEvent()) + ARROW_EVENT_SUFFIX, e.getWhen(), e.getModifiers());
            }
            this.fireActionPerformed_(e);
        }
    }

    private void fireActionPerformed_(ActionEvent e) {
        if (!this.showPopup(e)) {
            super.fireActionPerformed(e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int size;
        int x;
        super.paintComponent(g);
        Color origColor = g.getColor();
        int w = this.getWidth();
        int h = this.getHeight();
        Insets borderInsets = this.originalBorder.getBorderInsets(this);
        boolean isEnabled = this.isEnabled();
        int y1 = borderInsets.top;
        int y2 = h - borderInsets.bottom;
        if (this.getComponentOrientation().isLeftToRight()) {
            x = w - this.arrowSpaceWidth - borderInsets.right + 1;
            size = (this.arrowWidth + 1) / 2;
            this.paintTriangle(g, x + this.arrowSpaceWidth / 2, (h - size) / 2, size, isEnabled);
        } else {
            x = this.arrowSpaceWidth + borderInsets.left - 1;
            size = (this.arrowWidth + 1) / 2;
            this.paintTriangle(g, x - 1 - this.arrowWidth, (h - size) / 2, size, isEnabled);
        }
        if (this.isDivided && (this.isMouseOver || this.hasFocus()) && isEnabled) {
            int gradientHeight = Math.max((y2 - y1 + 1) / 5, 1);
            float gradientIncrement = 100.0f / (float)gradientHeight;
            Color foregroundColor = this.getForeground();
            int i = 0;
            while (i < gradientHeight) {
                g.setColor(new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), (int)(gradientIncrement * (float)(i + 1))));
                g.drawLine(x, y1 + i, x, y1 + i);
                g.drawLine(x, y2 - i, x, y2 - i);
                ++i;
            }
            Color dividerColor = new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), 100);
            g.setColor(dividerColor);
            g.drawLine(x, y1 + gradientHeight, x, y2 - gradientHeight);
        }
        g.setColor(origColor);
    }

    public void setDivided(boolean isDivided) {
        this.isDivided = isDivided;
    }

    public boolean isDivided() {
        return this.isDivided;
    }

    private void paintTriangle(Graphics g, int x, int y, int size, boolean isEnabled) {
        Color oldColor = g.getColor();
        size = Math.max(size, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        Color foregroundColor = this.getForeground();
        if (isEnabled) {
            g.setColor(foregroundColor);
        } else if (!isEnabled) {
            g.setColor(new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), 100));
        }
        int j = 0;
        int i = size - 1;
        while (i >= 0) {
            g.drawLine(mid - i, j, mid + i, j);
            ++j;
            --i;
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public void setArrowPopupMenu(JPopupMenu arrowPopupMenu) {
        this.arrowPopupMenu = arrowPopupMenu;
    }

    public JPopupMenu getArrowPopupMenu() {
        return this.arrowPopupMenu;
    }
}

