unit UnitFrmEditItem;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons, RichEdit, Menus, Clipbrd;

type
  TFrmEditItem = class(TForm)
    RichEdit1: TRichEdit;
    btnSave: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    btnRmvSpaces: TSpeedButton;
    btnRemoveLinefeeds: TSpeedButton;
    btnTrim: TSpeedButton;
    Label3: TLabel;
    combCase: TComboBox;
    SpeedButton1: TSpeedButton;
    PopupMenu1: TPopupMenu;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    bntSavePopup: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnSaveClick(Sender: TObject);
    procedure btnRmvSpacesClick(Sender: TObject);
    procedure btnRemoveLinefeedsClick(Sender: TObject);
    procedure btnTrimClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RichEdit1ContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bntSavePopupClick(Sender: TObject);
  private
    { Private declarations }
    xcaller : TForm;
    mon : boolean;
  public
    { Public declarations }
    procedure SetText(s : string; caller : TForm);
  end;

var
  FrmEditItem: TFrmEditItem;

implementation

uses UnitFrmMainPopup, UnitPaste, UnitToken, UnitFrmClipboardManager,
  UnitPopupGenerate, UnitClipQueue, UnitMisc, UnitFrmDebug;

{$R *.dfm}

{ TForm1 }

procedure TFrmEditItem.SetText(s: string; caller : TForm);
begin
    RichEdit1.Lines.Clear;
    RichEdit1.Text := s;

    xcaller := caller;
    // RichEdit control will ignore text changes without the .Clear on the first
    // time it is displayed

    if xcaller <> nil then begin
        self.Top := xcaller.Top + xcaller.Height div 2 - self.Height div 2;
        self.Left := xcaller.Left + xcaller.Width div 2 - self.Width div 2;
    end;
end;

procedure TFrmEditItem.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    if self.mon then
        frmClipboardManager.SetDisableMonitoring(false);
end;

procedure TFrmEditItem.FormCreate(Sender: TObject);
begin
    FrmDebug.AppendLog('FormEdit - creating');

    btnRmvSpaces.Glyph := FrmMainPopup.imgFlush.Picture.Bitmap;
    btnRemoveLinefeeds.Glyph := FrmMainPopup.imgFlush.Picture.Bitmap;
    btnTrim.Glyph := FrmMainPopup.imgFlush.Picture.Bitmap;


end;

procedure TFrmEditItem.bntSavePopupClick(Sender: TObject);
var ci : TClipItem;
begin
    paste.SetClipboardOnlyOnce;
    paste.SendPlainText(richedit1.text);
    ci := TClipItem.Create;
    ci.GetClipboardItem(application.Icon.Handle);
    ClipQueue.InsertAtStart(ci);

    self.ModalResult := mrOK;
    if self.Visible then self.Close;
     
end;

procedure TFrmEditItem.btnCancelClick(Sender: TObject);
begin
    self.ModalResult := mrCancel;
    if self.Visible then self.Close;
    
end;

procedure TFrmEditItem.FormShow(Sender: TObject);
begin
    //
    // show window just above current mouse position
    // Keep if rom falling off the top of the screen
    //

    if xcaller = nil then begin
        self.Top := mouse.CursorPos.Y - 80;
        if (self.top < 0) then self.Top := 0;
    end;

    //
    // keep preview from falling off the bottom or right
    // of the screen
    //
    if (self.Top + self.Height) > screen.DesktopRect.bottom then
        self.top := screen.DesktopRect.bottom - self.Height;
    if (self.Left + self.Width) > screen.DesktopRect.right then
        self.Left := screen.DesktopRect.right - self.Width;


    self.mon := frmClipboardManager.GetMonitoring;
    if self.mon then FrmClipboardManager.SetDisableMonitoring(true);
end;

procedure TFrmEditItem.Paste1Click(Sender: TObject);
begin
    RichEdit1.PasteFromClipboard;
end;

procedure TFrmEditItem.RichEdit1ContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
begin
    copy1.Enabled := false;
    if clipboard.AsText <> '' then begin
        Copy1.Enabled := true;
    end;

    cut1.Enabled := false;
    copy1.Enabled := false;

    if richedit1.SelText <> '' then begin
        cut1.Enabled := true;
        copy1.Enabled := true;
    end;


end;

procedure TFrmEditItem.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key = VK_ESCAPE then begin
        key := 0;
        btnCancel.click;
    end;
end;

procedure TFrmEditItem.btnSaveClick(Sender: TObject);
begin
    Paste.PlaceOnClipboardDontBypassClipboardManager(richedit1.text);

    self.ModalResult := mrOK;
    if self.Visible then self.Close;
    
end;

procedure TFrmEditItem.btnRmvSpacesClick(Sender: TObject);
var s : string;
const SPACE = ' ';
const DBLSPACE = SPACE+SPACE;
begin
    if RichEdit1.SelText = '' then begin
        RichEdit1.SelectAll;
    end;
    s := RichEdit1.SelText;
    while pos(DBLSPACE,s) <> 0 do begin
        s := StringReplace(s,DBLSPACE,SPACE,[rfReplaceAll]);
    end;
    RichEdit1.SelText := s;
end;

procedure TFrmEditItem.btnRemoveLinefeedsClick(Sender: TObject);
var s : string;
const LINEFEED = #13#10;
const DBLLINEFEED = LINEFEED+LINEFEED;
begin
    if RichEdit1.SelText = '' then begin
        RichEdit1.SelectAll;
    end;
    s := RichEdit1.SelText;
    while pos(DBLLINEFEED,s) <> 0 do begin
        s := StringReplace(s,DBLLINEFEED,LINEFEED,[rfReplaceAll]);
    end;
    RichEdit1.SelText := s;
end;

procedure TFrmEditItem.btnTrimClick(Sender: TObject);
begin
    if RichEdit1.SelText = '' then begin
        RichEdit1.SelectAll;
    end;
     richedit1.SelText := Trim(RichEdit1.SelText);
end;

procedure TFrmEditItem.Copy1Click(Sender: TObject);
begin
    richedit1.CopyToClipboard;
end;

procedure TFrmEditItem.Cut1Click(Sender: TObject);
begin
    RichEdit1.CutToClipboard;
end;

procedure TFrmEditItem.SpeedButton1Click(Sender: TObject);
begin
    if RichEdit1.SelText = '' then begin
        RichEdit1.SelectAll;
    end;
    case combCase.ItemIndex of
    0 : richedit1.SelText := UpperCase(richedit1.SelText);
    1 : richedit1.SelText := LowerCase(richedit1.SelText);
    2 : richedit1.SelText := UnitToken.CapitalizeWords(richedit1.SelText);
    end;
end;

procedure TFrmEditItem.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key = VK_ESCAPE then begin
        key := 0;
    end;
end;

end.
