unit UnitFolderWriteTest;

interface

uses Forms, Dialogs, SysUtils, Windows, UnitMisc;

type TFolderWriteTest = class

        err : integer;
        lasterr : string;
    public
        function CurrentFolder : string;
        function CanWrite(filename : string = 'TestFile.txt') : boolean;
        function IsDesktop : boolean;
end;

var FolderWriteTest : TFolderWriteTest;
implementation


{ TFolderWriteTest }

function TFolderWriteTest.CanWrite(filename : string = 'TestFile.txt'): boolean;
var f : file;
    name : string;
    cnt : integer;
    i : array[0..0] of integer;
begin
    result := false;

    name :=  self.CurrentFolder + filename;
    try
        assign(f,name);
        rewrite(f);
        close(f);

        assign(f,name);
        reset(f,1);
        i[0] := 2112;
        blockwrite(f,i,sizeof(i),cnt);
        close(f);
        result := cnt = sizeof(i);

        assign(f,name);
        reset(f,1);
        blockread(f,i,sizeof(i),cnt);
        close(f);
        result := result and (i[0]=2112);

        result := SysUtils.DeleteFile(name) and result;
    except
        lasterr := SysErrorMessage(GetLastError);
        //self.err := IOResult;
    end;


end;

function TFolderWriteTest.CurrentFolder: string;
begin
    result := UnitMisc.GetAppPath;
end;

function TFolderWriteTest.IsDesktop: boolean;
var folder : string;
begin
    folder := ExtractFileName(ExcludeTrailingPathDelimiter(self.CurrentFolder));
    result :=  lowercase(folder) = 'desktop';
end;

initialization
begin
    FolderWriteTest := TFolderWriteTest.create();
    if not FolderWriteTest.CanWrite  then begin
        ShowMessage('Error: ' + FolderWRiteTest.lasterr + #13#10#13#10 +
                    'Cannot create files in the location: '#13#10 +
                     FolderWriteTest.CurrentFolder  + #13#10
                    );
        Application.Terminate;
        ExitProcess(1);
    end;


    if FolderWriteTest.IsDesktop then begin
        ShowMessage('This executable cannot be run directly from the Desktop.');

        Application.Terminate;
        ExitProcess(1);
    end;

    if Application.Terminated then EXIT;

    if not UnitMisc.isProgramFilesPath then begin
        if not FolderWriteTest.CanWrite('test.dll') then begin
           ShowMessage('Error: ' + FolderWRiteTest.lasterr + #13#10#13#10 +
                        'A protection program is preventing DLLs from being created in: '#13#10 +
                         FolderWriteTest.CurrentFolder  + #13#10
                        );
            Application.Terminate;
            ExitProcess(1);
        end;
    end;


    if Application.Terminated then EXIT;

    if not (DirectoryExists(FolderWriteTest.CurrentFolder + '\clipdatabase')) then EXIT;

    if not FolderWriteTest.CanWrite('\clipdatabase\test.dat') then begin
       ShowMessage('Error: ' + FolderWRiteTest.lasterr + #13#10#13#10 +
                    'Cannot create file in the location: '#13#10 +
                     FolderWriteTest.CurrentFolder  + #13#10
                    );
        Application.Terminate;
        ExitProcess(1);
    end;

end;
end.
