program ArsClip;





{$R *.dres}

uses
  Forms,
  Windows,
  SysUtils,
  Dialogs,
  Math,
  UnitFrmDebug in 'UnitFrmDebug.pas' {FrmDebug},
  UnitFolderWriteTest in 'UnitFolderWriteTest.pas',
  UnitMisc in 'UnitMisc.pas',
  UnitFrmMainPopup in 'UnitFrmMainPopup.pas' {FrmMainPopup},
  UnitFrmConfig in 'UnitFrmConfig.pas' {FrmConfig},
  UnitFrmSysTrayMenu in 'UnitFrmSysTrayMenu.pas' {frmSysTrayMenu},
  UnitFrmClipboardManager in 'UnitFrmClipboardManager.pas' {frmClipboardManager},
  UnitListBoxMover in 'UnitListBoxMover.pas',
  UnitFrmPasteSelected in 'UnitFrmPasteSelected.pas' {FrmPasteSelected},
  UnitClipQueue in 'UnitClipQueue.pas',
  UnitFrmAbout in 'UnitFrmAbout.pas' {FrmAbout},
  UnitOtherQueue in 'UnitOtherQueue.pas',
  UnitFrmHotKey in 'UnitFrmHotKey.pas' {FrmHotkey},
  UnitKeyboardQuery in 'UnitKeyboardQuery.pas',
  UnitFrmChainWatcher in 'UnitFrmChainWatcher.pas' {FrmChainWatcher},
  UnitFrmPermanentNew in 'UnitFrmPermanentNew.pas' {FrmPermanent},
  UnitHotKey in 'UnitHotKey.pas',
  UnitPaste in 'UnitPaste.pas',
  UnitReportError in 'UnitReportError.pas' {FrmReportError},
  UnitToken in 'UnitToken.pas',
  UnitTWideChar in 'UnitTWideChar.pas',
  UnitFrmDummyUnicodeTooltip in 'UnitFrmDummyUnicodeTooltip.pas' {FrmDummyUnicodeTooltip},
  UnitSound in 'UnitSound.pas',
  UnitFrmEditItem in 'UnitFrmEditItem.pas' {FrmEditItem},
  UnitMenuItemTagdata in 'UnitMenuItemTagdata.pas',
  UnitSpecialPaths in 'UnitSpecialPaths.pas',
  UnitPopupGenerate in 'UnitPopupGenerate.pas',
  UnitFrmPermanentEdit in 'UnitFrmPermanentEdit.pas' {FrmPermanentEdit},
  UnitFrmDummyClipboardBar in 'UnitFrmDummyClipboardBar.pas' {frmClipboardBar},
  UnitFrmSearch in 'UnitFrmSearch.pas' {frmSearch},
  UnitFrmInstance in 'UnitFrmInstance.pas' {FrmDummyInstance},
  UnitCRC32 in 'UnitCRC32.PAS',
  UnitDestinationList in 'UnitDestinationList.pas',
  UnitTaskArray in 'UnitTaskArray.pas',
  UnitMiscCom in 'UnitMiscCom.pas',
  UnitFrmJumpList in 'UnitFrmJumpList.pas' {FrmJumpList},
  UnitFrmEditTextExternal in 'UnitFrmEditTextExternal.pas' {frmEditTextExternal},
  UnitFrmEditHistory in 'UnitFrmEditHistory.pas' {frmEditHistory},
  UnitIntegrity in 'UnitIntegrity.pas',
  UnitClipMenu in 'UnitClipMenu.pas' {FrameItemMenu: TFrame},
  UnitFramePopup in 'UnitFramePopup.pas' {ACPopup: TFrame},
  UnitACPopupClicks in 'UnitACPopupClicks.pas',
  UnitFrmPreviewPopup in 'UnitFrmPreviewPopup.pas' {frmPreviewPopup},
  UnitFrmTooltipNew in 'UnitFrmTooltipNew.pas' {FrmTooltipNew},
  UnitFrmTriggerWindow in 'UnitFrmTriggerWindow.pas' {FrmTriggerWindow},
  UnitFrameMySlide in '..\MySlideTest2\UnitFrameMySlide.pas' {MySlide: TFrame},
  UnitFrmPermanentPreview in 'UnitFrmPermanentPreview.pas' {FrmPermanentPreview},
  UnitFrmCheckForUpdate in '..\CheckForUpdate\UnitFrmCheckForUpdate.pas' {FrmCheckForUpdate},
  UnitDropFile in 'UnitDropFile.pas',
  UnitFrmSizeRichtext in 'UnitFrmSizeRichtext.pas' {frmSizeRichtext},
  UnitFrmClipMenuNew in 'UnitFrmClipMenuNew.pas' {FrmClipMenuNew},
  UnitFrameClipDisplay in 'UnitFrameClipDisplay.pas' {FrameClipDisplay: TFrame},
  UnitHTMLConvert in 'UnitHTMLConvert.pas',
  UnitDragClip in 'UnitDragClip.pas',
  UnitFileCatch in 'UnitFileCatch.pas',
  UnitFrmDummyAlwaysOnTopFix in 'UnitFrmDummyAlwaysOnTopFix.pas' {FrmDummyAllwaysOnTopFix},
  UnitMyCursor in 'UnitMyCursor.pas',
  UnitDummyShellForm in 'UnitDummyShellForm.pas' {FrmDummyShellForm},
  UnitClipDatabase in 'UnitClipDatabase.pas',
  UnitFolderMonitor in 'UnitFolderMonitor.pas',
  UnitFrmImport in 'UnitFrmImport.pas' {FrmImport},
  UnitFramePermanentClips in 'UnitFramePermanentClips.pas' {FramePermanentClips: TFrame},
  UnitFrameImport in 'UnitFrameImport.pas' {FrameImport: TFrame},
  SQLite3Lib in 'SQLite3Lib.pas',
  SQLite3Classes in 'SQLite3Classes.pas',
  SQLite3Constants in 'SQLite3Constants.pas',
  UnitFrmDatabaseUpdate in 'UnitFrmDatabaseUpdate.pas' {frmDatabaseUpdate},
  UnitJS in 'UnitJS.pas',
  UnitFrmShared in 'UnitFrmShared.pas' {frmShared},
  UnitThreadAttach in 'UnitThreadAttach.pas',
  UnitFocusManager in 'UnitFocusManager.pas';

{$R *.res}
{$R icon.res}

var ci : TClipITem;
    par : string;

    DefaultParam : boolean;
    FullLoad : boolean;
begin
    DefaultParam := false;
    FullLoad := false;

    par := '';
    if ParamCount = 1 then begin
        par := lowercase(ParamStr(1));
    end;

    if par = '-popup' then begin
        Application.OnException := FrmMainPopup.ApplicationException;
        FrmInstance_Init(INST_POPUP);
        Application.ProcessMessages;
        //Application.Run;
        //EXIT;
    end else if par = '-second' then begin
        // a second instance does not get a FrmInstance messege window
    end else begin
        DefaultParam := true;
    end;
    if DefaultParam then begin
        FrmInstance_Init(INST_INIT);

        if not FrmInstance_IsFirst then  begin
            // detect Jump List data
            if par = '' then begin
                Frminstance_Init(INST_DEFAULT);
            end else begin
                FrmInstance_init(par);
            end;
            Application.ProcessMessages;
        end;
    end;



    if (integrity.isHigh(Application.Handle)) and
        UnitMisc.isProgramFilesPath then begin
        ShowMessage('ArsClip: Running as Administrator in Program Files folder not allowed.');
        Application.Terminate;
    end;

    if not Application.Terminated then begin
        Application.Title := 'ArsClip';
        Application.Initialize;

        Application.MainFormOnTaskBar := true;    // while this seems backwards, it prevents a ghost taskbar window
        Application.ShowMainForm := false;




        Application.CreateForm(TFrmMainPopup, FrmMainPopup);
  Application.CreateForm(TfrmDatabaseUpdate, frmDatabaseUpdate);
  Application.CreateForm(TfrmShared, frmShared);
  if (frmMainPopup.Visible) then begin
            frmMainPopup.Hide;
        end;

        Application.CreateForm(TFrmDebug, FrmDebug);
        Application.CreateForm(TFrmDummyShellForm, FrmDummyShellForm);
        Application.CreateForm(TFrmImport, FrmImport);
        FrmDebug.AppendLog('Starting');
        Application.CreateForm(TFrmDummyAllwaysOnTopFix, FrmDummyAllwaysOnTopFix);

        FrmDebug.AppendLog('TFrmMainpopup');

        FrmMainPopup.Visible := false;



        Application.OnException := FrmMainPopup.ApplicationException;
        TClipDatabase.preLoad;

        Application.CreateForm(TFrmPermanentPreview, FrmPermanentPreview);
        FrmDebug.AppendLog('TFrmPermanentPreview');
        Application.CreateForm(TFrmCheckForUpdate, FrmCheckForUpdate);
        FrmDebug.AppendLog('TFrmCheckForUpdate');
        Application.CreateForm(TfrmSizeRichtext, frmSizeRichtext);
        FrmDebug.AppendLog('TfrmSizeRichtext');
        Application.CreateForm(TFrmClipMenuNew, FrmClipMenuNew);
        FrmDebug.AppendLog('TFrmClipMenuNew');

        Application.CreateForm(TFrmDummyInstance, FrmDummyInstance);
        FrmDummyInstance.Visible := false;
        FrmDebug.AppendLog('FrmDummyInstance');
        Application.CreateForm(TfrmClipboardBar, frmClipboardBar);
        FrmDebug.AppendLog('frmClipboardBar');
        Application.CreateForm(TfrmSearch, frmSearch);
        FrmDebug.AppendLog('frmSearch');
        Application.CreateForm(TfrmEditHistory, frmEditHistory);
        FrmDebug.AppendLog('frmNewEditHistory');
        Application.CreateForm(TfrmPreviewPopup, frmPreviewPopup);
        FrmDebug.AppendLog('frmPreviewPopup');
        Application.CreateForm(TFrmAbout, FrmAbout);
        FrmDebug.AppendLog('FrmAbout');
        Application.CreateForm(TfrmClipboardManager, frmClipboardManager);
        FrmDebug.AppendLog('frmClipboardManager');
        Application.CreateForm(TFrmHotkey, FrmHotkey);
        FrmDebug.AppendLog('FrmHotkey');

        Application.CreateForm(TFrmPermanent, FrmPermanent);
        FrmDebug.AppendLog('FrmPermanent');
        Application.CreateForm(TFrmPermanentEdit, FrmPermanentEdit);
        FrmDebug.AppendLog('FrmPermanentEdit');

        Application.CreateForm(TFrmPasteSelected, FrmPasteSelected);
        FrmDebug.AppendLog('FrmPasteSelected');
        Application.CreateForm(TFrmEditItem, FrmEditItem);
        FrmDebug.AppendLog('FrmEditItem');
        {Config must access other forms to set settings, making it last is safest}


        Application.CreateForm(TFrmConfig, FrmConfig);
        FrmDebug.AppendLog('FrmConfig');
        if par = '-paste' then begin
            ci := TClipItem.Create;
            ci.GetClipboardItem(0);
            Paste.SendClip(ci);
            Application.Terminate;
            EXIT;
        end;

        Application.CreateForm(TfrmSysTrayMenu, frmSysTrayMenu);
        FrmDebug.AppendLog('frmSysTrayMenu');
        Application.CreateForm(TFrmChainWatcher, FrmChainWatcher);
        FrmDebug.AppendLog('FrmChainWatcher');
        Application.CreateForm(TFrmReportError, FrmReportError);
        FrmDebug.AppendLog('FrmReportError');
        Application.CreateForm(TFrmDummyUnicodeTooltip, FrmDummyUnicodeTooltip);
        FrmDebug.AppendLog('FrmDummyUnicodeTooltip');
        Application.CreateForm(TFrmJumpList, FrmJumpList);
        FrmDebug.AppendLog('FrmJumpList');

        // prevent clipboard messages until after all forms are loaded


        // a pinned icon activated jumplist when the program isn't running yet
        if (par <> '') and FrmJumpList.IsTaskArgument(par) then begin
            FrmJumpList.HandleTaskArgument(par);
        end;


        FrmDebug.AppendLog('Importing clips');
        TClipDatabase.importdata(frmDatabaseUpdate);
        if (FrmConfig.cbGlobalClipboard.Checked) then begin
            TGlobalClipboard.JoinInstancePool;
        end;

        // testing to make sure the clipboard is not changing when the temp list
        // may be altered
        frmClipboardManager.ActivateAfterLoad;
        FrmDebug.AppendLog('ClipboardManager - Activated');
        FrmMainPopup.ActivateAfterLoad;

        UnitMyCursor.CreateCustomCursor;

         // must be AFTER Config and ClipboardBar
        if frmconfig.ClipboardBarSetVisible then begin
            frmconfig.LoadClipboardBarState;
        end;

        frmSysTrayMenu.AfterLoadReport;
        

        FrmDebug.AppendLog('==Load Finished==');
        FullLoad := true;
    end else begin
        // TODO - add error reporting here
    end;




    ShowWindow(Application.Handle, SW_HIDE);
    Application.Run;
    FrmInstance_DeInit;


end.
